/*
 * Lösung für Übung 7.5.4 - Preismacht
 */
#include <iostream>
#include <string>

struct Date
{
  // Sie können Standardparameter für den Konstuktor verwenden, sodass Sie auch
  // ein "leeres" Datum leicht anlegen können
  Date(int day = 0, int month = 0, int year = 0)
    : day(day), month(month), year(year)
  {
  }
  int day = 0;
  int month = 0;
  int year = 0;
  // Hilfreich zur testweisen Konsolenausgabe
  std::string toString()
  {
    return std::to_string(day) + "." + std::to_string(month) + "." + std::to_string(year);
  }
};

class Article
{
 public:
  Article(const std::string& name, double price)
    : name(name), price(price)
  {
  }
  std::string getName()
  {
    return name;
  }
  double getPrice()
  {
    return price;
  }
  void setPrice(double newPrice)
  {
    if (newPrice <= 0)
    {
      std::cout << "Preis nicht valide!" << std::endl;
      // Der Preis wird nicht geändert
      return;
    }
    price = newPrice;
  }
  virtual void sell(const Date& currentDate)
  {
    std::cout << name << " verkauft" << std::endl;
  }
 private:
  std::string name;
  double price;
};

class FoodArticle : public Article
{
public:
  FoodArticle(const std::string& name, double price, const Date& expirationDate)
    : Article(name, price), expirationDate(expirationDate)
  {
  }
  Date getExpirationDate()
  {
    return expirationDate;
  }
 private:
  Date expirationDate;
};

class TechArticle : public Article
{
 public:
  TechArticle(const std::string& name, double price, int yearsOfWarranty)
    : Article(name, price), yearsOfWarranty(yearsOfWarranty)
  {
  }
  int getYearsOfWarranty()
  {
    return yearsOfWarranty;
  }
  Date getWarrantyExpirationDate()
  {
    return warrantyExpirationDate;
  }
  void sell(const Date& currentDate) override
  {
    std::cout << getName() << " verkauft" << std::endl;
    warrantyExpirationDate = currentDate;
    warrantyExpirationDate.year += yearsOfWarranty;
  }
 private:
  int yearsOfWarranty = 0;
  // Das Ablaufdatum wird erst beim Verkauf gesetzt.
  Date warrantyExpirationDate;
};

int main()
{
  TechArticle laptop("Thinkpad", 799, 3);
  TechArticle freezer("Arktis 3000", 1200, 5);
  FoodArticle milk("Vollmilch", 1.38, Date(25, 5, 2021));

  const Date today(4, 5, 2021);
  laptop.sell(today);
  freezer.sell(today);
  milk.sell(today);

  std::cout << "Der Laptop hat Garantie bis zum "
    << laptop.getWarrantyExpirationDate().toString() << std::endl;

  std::cout << "Der K\201hlschrank hat Garantie bis zum "
    << freezer.getWarrantyExpirationDate().toString() << std::endl;
  return 0;
}
