/*
 * Lösung für Übung 7.5.2 - Tierhierarchie
 */
#include <iostream>
#include <string>

class Animal
{
 public:
  Animal(const std::string& name)
    : name(name)
  {}
  virtual void eat() const
  {
    std::cout << name << " isst" << std::endl;
  }
  void rename(const std::string& newName)
  {
    name = newName;
  }
  std::string getName()
  {
    return name;
  }
 protected:
  std::string name;
};

class Cat : public Animal
{
 public:
  Cat(const std::string& name)
    : Animal(name)
  {
  }
  void eat() const override
  {
    std::cout << "Katze " << name << " isst eine Maus" << std::endl;
  }
};

class Mouse : public Animal
{
 public:
  Mouse(const std::string& name)
    : Animal(name)
  {
  }
  void eat() const override
  {
    std::cout << "Maus " << name << " isst K\204se" << std::endl;
  }
};

int main()
{
  // Die Katzen sind als Konstanten definiert
  const Cat mia("Mia");
  const Cat carlo("Carlo");
  mia.eat();
  carlo.eat();

  // Eine nicht-konstante Maus
  Mouse mouse("Philipp");
  mouse.eat();
  std::cout << "Maus " << mouse.getName();
  mouse.rename("Despereaux");
  std::cout << " hei\341t nun " << mouse.getName();
  return 0;
}
