/*
 * Lösung für Übung 6.5.3	- Blockbuster
 * 
 * searchKeywordMulti() ist die Bonusfunktion
 */
#include <iostream>
#include <string>
#include <vector>

struct Movie
{
  Movie(const std::string& title, int year, const std::vector<std::string>& keywords)
    : title(title), year(year), keywords(keywords)
  {
  }
  std::string title;
  int year;
  std::vector<std::string> keywords;
};

Movie searchKeyword(const std::vector<Movie>& movies, const std::string& keyword)
{
  for (Movie movie : movies)
  {
    for (std::string movieKeyword : movie.keywords)
    {
      if (movieKeyword == keyword)
      {
        return movie;
      }
    }
  }
  // Den "leeren Film" zurückgeben
  return Movie("", 0, {});
}

std::vector<Movie> searchKeywordMulti(const std::vector<Movie>& movies, const std::string& keyword)
{
  std::vector<Movie> result;
  for (Movie movie : movies)
  {
    for (std::string movieKeyword : movie.keywords)
    {
      if (movieKeyword == keyword)
      {
        result.push_back(movie);
      }
    }
  }
  return result;
}

int main()
{
  std::vector<Movie> movies = {
    Movie("Der Pate", 1972, { "Mafia", "Drogen", "Drama" }),
    Movie("Leon der Profi", 1994, { "Mafia", "Drama", "Rache" }),
    Movie("Zur\201ck in die Zukunft", 1985, { "Zeitreisen", "Kom\224die" }),
    Movie("Forrest Gump", 1994, { "Kom\224die", "Drama", "Melodram" })
  };

  Movie drama = searchKeyword(movies, "Drama");
  std::cout << "Einfache Suche: " << std::endl << "  " << drama.title << std::endl;

  std::vector<Movie> dramas = searchKeywordMulti(movies, "Drama");
  std::cout << "Mehrfachsuche: " << std::endl;
  for (Movie movie : dramas)
  {
    std::cout << "  " << movie.title << std::endl;
  }
  return 0;
}
