/*
 * Lösung für Übung 6.5.1	- Schau mir in die Augen
 *
 * Die Hilfsfunktion colorToString() ist der "Bonus"
 */
#include <iostream>
#include <string>

enum class Color { Brown, Blue, Green, Grey };

std::string colorToString(Color color)
{
  switch (color)
  {
    case Color::Brown:
      return "Braun";
    case Color::Blue:
      return "Blau";
    case Color::Green:
      return "Gr\201n";
    case Color::Grey:
      return "Grau";
    default:
      std::cerr << "Unbekannte Augenfarbe " << static_cast<int>(color) << std::endl;
      return "";
  }
}

class Person
{
public:
  Person(const std::string& f, const std::string& l, int a, Color ec)
    : firstName(f), lastName(l), age(a), eyeColor(ec)
  {
  }
  std::string toString()
  {
    return lastName + ", " + firstName
      + ". Alter: " + std::to_string(age)
      + ". Augenfarbe: " + colorToString(eyeColor);
  }
  std::string firstName;
  std::string lastName;
  int age = -1;
  Color eyeColor;
};

int main()
{
  Person melanie("Melanie", "Muster", 42, Color::Green);
  Person markus("Markus", "Muster", 41, Color::Brown);

  std::cout << melanie.toString() << std::endl;
  std::cout << markus.toString() << std::endl;
  return 0;
}
