/*
 * Lösung für Übung 5.7.4 - Charakterstudie
 */
#include <algorithm>
#include <iostream>
#include <map>
#include <string>
#include <vector>

std::map<char, int> countCharacters(std::string input)
{
  // In Kleinbuchstaben umwandeln. Es ist Ansichtssache, ob wir das hier wollen.
  // Falls Sie das in Ihrer Lösung nicht gemacht haben, ist das auch in Ordnung.
  std::transform(input.begin(), input.end(),
    input.begin(), tolower);

  std::map<char, int> characterCounts;
  for (char c : input)
  {
    characterCounts[c] = characterCounts[c] + 1;
  }
  return characterCounts;
}

void printCharacterCounts(const std::map<char, int>& characterCounts)
{
  for (std::pair<char, int> count : characterCounts)
  {
    std::cout << count.first << ":\t" << count.second << std::endl;
  }
}

int main()
{
  std::string test;
  test = "aaAbbc";
  std::cout << test << ": " << std::endl;
  printCharacterCounts(countCharacters(test));
  test = "1234567";
  std::cout << test << ": " << std::endl;
  printCharacterCounts(countCharacters(test));
  test = "Ein anderer Text";
  std::cout << test << ": " << std::endl;
  printCharacterCounts(countCharacters(test));
  return 0;
}
