/*
 * Lösung für Übung 5.7.3 - Das Mathegenie
 */
#include <iostream>
#include <string>
#include <algorithm>
#include <vector>

// Die Funktion split() auf Kapitel 5.3
std::vector<std::string> split(const std::string& str,
  char delimiter = ',')
{
  std::vector<std::string> parts;
  size_t start = 0;
  size_t end = str.find(delimiter);
  // Wenn die Suche zu keinem Ergebnis führt, nimmt der
  // Rückgabewert den speziellen Wert npos an
  while (end != std::string::npos)
  {
    parts.push_back(str.substr(start, end - start));
    start = end + 1;
    end = str.find(delimiter, start);
  }
  parts.push_back(str.substr(start, end));
  return parts;
}

int parseComputation(std::string input)
{
  // Alle Leerzeichen entfernen
  // Für Profis gäbe es auch die Standard Library-Variante:
  // input.erase(remove_if(input.begin(), input.end(), isspace), input.end());
  for (int i = 0; i < input.size(); i++)
  {
    if (input.at(i) == ' ')
    {
      input.erase(i, 1);
    }
  }
  std::vector<std::string> parts = split(input, '+');
  int result = 0;
  for (std::string part : parts)
  {
    result += std::stoi(part);
  }
  return result;
}

int main()
{
  std::string test;
  test = "4 + 2";
  std::cout << test << ": " << parseComputation(test) << std::endl;
  test = "2+3+4";
  std::cout << test << ": " << parseComputation(test) << std::endl;
  test = "3+1 + 10 +123 ";
  std::cout << test << ": " << parseComputation(test) << std::endl;
  return 0;
}
