/*
 * Lösung für Übung 5.7.2 - Ampel-Lampe
 */
#include <iostream>
#include <string>
#include <algorithm>

bool isAnagram(std::string first, std::string second)
{
  // Wenn die Worte nicht dieselbe Länge haben, können sie kein Anagramm sein
  if (first.size() != second.size())
  {
    return false;
  }

  // In Kleinbuchstaben umwandeln, sodass der Vergleich funktioniert
  std::transform(first.begin(), first.end(),
    first.begin(), tolower);
  std::transform(second.begin(), second.end(),
    second.begin(), tolower);

  for (char character : first)
  {
    size_t position = second.find(character);
    if (position == std::string::npos)
    {
      // Zeichen nicht gefunden, dies kann kein Anagramm sein
      return false;
    }
    // Das Zeichen wurde gefunden. Nun muss es entfernt werden, damit es nicht
    // ein zweites Mal gefunden wird. Für zwei gleiche Buchstaben im ersten String
    // müssen auch zwei gleiche Buchstaben im zweiten String auftauchen und nicht nur einer.
    second.erase(position, 1);
  }
  return true;
}

int main()
{
  std::string first;
  std::string second;
  first = "Ampel";
  second = "Lampe";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;
  first = "Lagerregal";
  second = "Regallager";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;
  first = "Lagerregal";
  second = "Regallager";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;
  first = "Geburt";
  second = "Erbgut";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;
  first = "Garkein ";
  second = "Anagramm";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;

  first = "asa";
  second = "asb";
  std::cout << first << " - " << second << ": " << isAnagram(first, second) << std::endl;
  return 0;
}
