/*
 * Lösung für Übung 5.7.1 - Lagerregal
 */
#include <iostream>
#include <string>
#include <algorithm>

bool isPalindrome(std::string input)
{
  // Zuerst in Kleinbuchstaben umwandeln, sodass der Vergleich funktioniert
  std::transform(input.begin(), input.end(),
    input.begin(), tolower);

  for (int i = 0; i < input.size(); i++)
  {
    // Vergleiche das erste mit dem letzten Zeichen, das zweite mit dem vorletzten, etc
    if (input.at(i) != input.at(input.size() - 1 - i))
    {
      // Kann kein Palindrom sein. Der Rest muss nicht weiter überprüft werden
      return false;
    }
  }
  return true;
}

int main()
{
  std::string test;
  test = "a";
  std::cout << test << ": " << isPalindrome(test) << std::endl;
  test = "Lagerregal";
  std::cout << test << ": " << isPalindrome(test) << std::endl;
  test = "kein palindrom";
  std::cout << test << ": " << isPalindrome(test) << std::endl;

  test = "aba";
  std::cout << test << ": " << isPalindrome(test) << std::endl;
  test = "abba";
  std::cout << test << ": " << isPalindrome(test) << std::endl;
  test = "abca";
  std::cout << test << ": " << isPalindrome(test) << std::endl;
  return 0;
}
