/*
 * Lösung für Übung 4.6.7	Noch 'ne Runde rückwärts
 *
 * Hier können Sie sehen, dass eine rekursive Implementierung
 * nicht immer einfacher und schöner sein muss als eine 
 * iterative. Letztendlich ist es Geschmackssache, aber ich
 * persönlich finde invertIterative() einfacher zu lesen als
 * invert()
 */
#include <iostream>
#include <string>

std::string invert(const std::string& text)
{
  if (text.size() == 0)
  {
    return "";
  }
  return invert(text.substr(1)) + text.at(0);
}

std::string invertIterative(const std::string& text)
{
  std::string result;
  for (char c : text)
  {
    result = c + result;
  }
  return result;
}

int main()
{
  std::cout << invert("Ein Text") << std::endl;
  std::cout << invertIterative("Ein Text") << std::endl;
  return 0;
}
