/*
 * Lösung für Übung 4.6.5. - Wir haben ein Date
 *
 * Die zwei neuen Funktionen heißen parseDate() und formatDate()
 * und sind am Anfang der Datei zu finden.
 * - parseDate() wird innerhalb von searchByDate() aufgerufen, nachdem
 *   die drei Zahlen einzeln vom Nutzer abgefragt wurden.
 * - formatDate() wird gegen Ende der main()-Funktion benutzt, wenn
 *   die Suchergebnisse ausgegeben werden.
 *
 * Zusätzlich werden die Funktionen in einer extra Testfunktion
 * testDateFunctions() aufgerufen, die testweise ein paar erwartete
 * Ergebnisse vergleicht, um sicherzustellen dass die Funktionen
 * sich verhalten wie erwartet. Das war nicht Teil der Aufgabenstellung,
 * ist aber dennoch eine gute Idee.
 */
#include <string>
#include <vector>
#include <iostream>
#include <algorithm>  // Für std::transform

int parseDate(int day, int month, int year)
{
  return day + month * 100 + year * 10000;
}

std::string formatDate(int date)
{
  return std::to_string(date % 100)
    + "." + std::to_string((date / 100) % 100)
    + "." + std::to_string(date / 10000);
}

bool checkTitlesAndDates(
  const std::vector<std::string>& eventTitles,
  const std::vector<int>& eventDates)
{
  if (eventTitles.size() != eventDates.size())
  {
    // Das muss ein Programmierfehler sein
    std::cerr << "Anzahl der Titel und Anzahl der Termine "
      << "muss gleich sein" << std::endl;
    return false;
  }
  // Plausibilität: Hat das Datum exakt acht Stellen?
  for (int date : eventDates)
  {
    if (date < 10000000 || date > 99999999)
    {
      std::cerr << "Falsches Datum: " << date << std::endl;
      return false;
    }
  }
  // Für die Suche muss das Datum sortiert sein
  for (int i = 1; i < eventDates.size(); i++)
  {
    if (eventDates.at(i - 1) > eventDates.at(i))
    {
      std::cerr << "Termine nicht sortiert" << std::endl;
      return false;
    }
  }
  return true;
}

bool testDateFunctions()
{
  /*
   * Diese Funktion vergleicht ein paar Aufrufe der Datumsfunktionen
   * mit den erwarteten Ergebnissen. Das soll mögliche Programmier-
   * fehler finden.
   */
  if (parseDate(3, 2, 2021) != 20210203)
  {
    std::cerr << "Fehler mit parseDate(3, 2, 2021)";
    return false;
  }
  if (parseDate(22, 11, 2023) != 20231122)
  {
    std::cerr << "Fehler mit parseDate(22, 11, 2023)";
    return false;
  }
  if (formatDate(20210203) != "3.2.2021")
  {
    std::cerr << "Fehler mit formatDate(20210203)";
    return false;
  }
  if (formatDate(20231122) != "22.11.2023")
  {
    std::cerr << "Fehler mit formatDate(20231122)";
    return false;
  }
  return true;
}

void showHeader(const std::string& text)
{
  for (int i = 0; i < text.size(); i++)
  {
    std::cout << "#";
  }
  std::cout << std::endl << text << std::endl;
  for (int i = 0; i < text.size(); i++)
  {
    std::cout << "#";
  }
  std::cout << std::endl;
}

int showSelection(const std::string& question,
  const std::vector<std::string>& answers)
{
  std::cout << question << std::endl;
  for (int i = 0; i < answers.size(); i++)
  {
    std::cout << (i+1) << ": " << answers.at(i) << std::endl;
  }
  std::cout << "Tippen Sie eine Zahl ein: ";
  int selection;
  std::cin >> selection;
  while (selection <= 0 || selection > answers.size())
  {
    std::cout << std::endl
      << "Eingabe inkorrekt. Bitte wiederholen: ";
    std::cin >> selection;
  }
  std::cout << "----------------------------" << std::endl;
  /*
   * Der Nutzer hat eine Zahl zwischen 1 und der Anzahl der
   * Elemente eingegeben. Als Programmierer erwarten wir
   * aber, dass die Zählung bei 0 beginnt. Daher muss die
   * 1 wieder abgezogen werden
   */
  return selection - 1;
}

bool findInString(std::string text, std::string query)
{
  /*
   * Um Groß- und Kleinschreibung beim Suchen zu
   * ignorieren, wandeln wir alles in Kleinbuchstaben um
   */
  std::transform(text.begin(), text.end(),
    text.begin(), tolower);
  std::transform(query.begin(), query.end(),
    query.begin(), tolower);

  /*
   * Mit .find() kann man innerhalb eines Strings nach
   * einem anderen String suchen. Wenn er nicht gefunden
   * wird, ist das Ergebnis std::string::npos (npos steht
   * für "no position")
   */
  return text.find(query) != std::string::npos;
}

std::vector<int> searchByTitle(
  const std::vector<std::string>& titles)
{
  std::cout << "Geben Sie ein Suchwort ein: ";
  std::string query;
  std::cin >> query;
  std::vector<int> selections;
  for (int i = 0; i < titles.size(); i++)
  {
    const std::string& title = titles.at(i);
    if (findInString(title, query))
    {
      // Der Suchbegriff wurde im i-ten Titel gefunden
      selections.push_back(i);
    }
  }
  return selections;
}

std::vector<int> searchByDate(const std::vector<int>& dates)
{
  /*
   * Suche alle Termine, die an oder nach dem angegebenen
   * Datum stattfinden.
   */
  std::cout << "Bitte geben Sie ein Datum ein, ab dem "
    << "nach Veranstaltungen gesucht werden soll."
    << std::endl;
  std::cout << "Tag: ";
  int day;
  std::cin >> day;
  std::cout<< "Monat: ";
  int month;
  std::cin >> month;
  std::cout << "Jahr: ";
  int year;
  std::cin >> year;
  const int query = parseDate(day, month, year);

  std::vector<int> selections;
  for (int i = 0; i < dates.size(); i++)
  {
    const int& date = dates.at(i);
    if (date >= query)
    {
      /*
       * Dies ist das erste gefundene Datum, was nicht vor
       * dem gesuchten Datum liegt. Daher geben wir alle
       * übrigen Termine aus. Dafür starten wir eine neue
       * for-Schleife beim i-ten Element und gehen von
       * dort bis zum Ende der Liste.
       */
      for (int j = i; j < dates.size(); j++)
      {
        selections.push_back(j);
      }
      // Schleife verlassen, da wir Termine gefunden haben
      break;
    }
  }
  return selections;
}

int main()
{
  const std::vector<std::string> eventTitles = {
    "Rock Concert",
    "Jazz Concert",
    "Hard-Rock Concert",
    "Classical Concert",
    "Jazz Concert"
  };
  // Speichern des Datums als JahrMonatTag, also YYYYMMDD
  const std::vector<int> eventDates = {
    20220417,
    20220822,
    20221011,
    20221027,
    20221203
  };
  if (!checkTitlesAndDates(eventTitles, eventDates))
  {
    // Fehlerhafter Datensatz
    return 1;
  }
  if (!testDateFunctions())
  {
    // Fehlerhafte Datumsfunktionen
    return 1;
  }

  showHeader("Willkommen beim digitalen Buchungssystem");
  const std::vector<std::string> searchTypes = {
      "nach Titel der Veranstaltung",
      "nach Termin der Veranstaltung"
  };
  const int selectedSearch = showSelection(
    "Wie wollen Sie suchen?",
    searchTypes);
  std::vector<int> eventsFound;
  switch (selectedSearch) {
  case 0:
    eventsFound = searchByTitle(eventTitles);
    break;
  case 1:
    eventsFound = searchByDate(eventDates);
    break;
  default:
    std::cerr << "Unerwarteter searchType: "
      << selectedSearch << std::endl;
    return 1;
  }
  if (eventsFound.size() == 0)
  {
    showHeader("Leider keine Veranstaltung gefunden");
  }
  else
  {
    showHeader("Veranstaltungen gefunden:");

    std::vector<std::string> selectionTexts;
    for (int index : eventsFound)
    {
      selectionTexts.push_back(eventTitles.at(index)
        + ", am " + formatDate(eventDates.at(index)));
    }
    int selected = showSelection(
      "Welche Veranstaltung wollen Sie buchen?",
      selectionTexts);

    showHeader("Sie haben gebucht: "
      + selectionTexts.at(selected));
  }
  return 0;
}
