/*
 * Lösung für Übung 4.6.3 - Join Me as well!
 */
#include <iostream>
#include <string>
#include <vector>

std::string join(const std::vector<std::string>& list, const std::string& delimiter)
{
  std::string result;
  for (int i = 0; i < list.size(); i++)
  {
    result += list.at(i);
    // Das Trennzeichen nur einfügen, wenn es nicht das letzte Element ist
    if (i < list.size() - 1)
    {
      result += delimiter;
    }
  }
  return result;
}

std::string join(const std::vector<int>& list, const std::string& delimiter)
{
  std::string result;
  for (int i = 0; i < list.size(); i++)
  {
    result += std::to_string(list.at(i));
    // Das Trennzeichen nur einfügen, wenn es nicht das letzte Element ist
    if (i < list.size() - 1)
    {
      result += delimiter;
    }
  }
  return result;
}

std::string join(const std::string input, const std::string& delimiter)
{
  std::string result;
  for (int i = 0; i < input.size(); i++)
  {
    result += input.at(i);
    // Das Trennzeichen nur einfügen, wenn es nicht das letzte Element ist
    if (i < input.size() - 1)
    {
      result += delimiter;
    }
  }
  return result;
}

int main()
{
  std::vector<std::string> list = { "Mehl", "Salz", "Ei", "Butter" };
  std::cout << join(list, ",") << std::endl;
  std::cout << join(list, " - ") << std::endl;

  std::vector<int> intList = { 1, 2, 3, 5, 8 };
  std::cout << join(intList, " -> ") << std::endl;

  std::cout << join("abcdef", " ") << std::endl;

  return 0;
}
