/*
 * Lösung für Übung 14.4.1 - Test-Driven Test Driver
 *
 * Bevor Sie die Methode startRide() so wie unten angegeben
 * implementiert haben, sollten Sie zuerst diese Variante benutzt haben:
 *  bool startRide(int gForces)
 *  {
 *   return true;
 *  }
 * um zu sehen, dass der Test diesen Programmierfehler auch findet.
 */
#include <iostream>

class TestDriver
{
public:
  TestDriver(int sensitivity)
    : sensitivity(sensitivity)
  {
  }
  bool startRide(int gForces)
  {
    // return true; // <- Testen Sie Ihren Test zuerst mit diesem Dummyresultat!
    sickness += sensitivity * gForces;
    if (sickness > 100)
    {
      std::cout << "... w\201rg" << std::endl;
      return false;
    }
    std::cout << "Testfahrt begonnen" << std::endl;
    return true;
  }
private:
  int sickness = 0;
  int sensitivity = 0;
};

void unitTests()
{
  TestDriver driver0(0);
  TestDriver driver5(5);
  TestDriver driver100(100);

  // Der unzerstörbare Testfahrer - ihm wird niemals schlecht
  for (int i = 0; i < 100; i++)
  {
    bool rideStarted = driver0.startRide(i);
    if (!rideStarted)
    {
      throw std::exception("Fahrt nicht gestartet");
    }
  }

  // Ein etwas empfindlicher Tester
  for (int i = 0; i < 5; i++)
  {
    bool rideStarted = driver5.startRide(4);
    if (!rideStarted)
    {
      throw std::exception("Fahrt nicht gestartet");
    }
  }
  for (int i = 0; i < 2; i++)
  {
    bool rideStarted = driver5.startRide(1);
    if (rideStarted)
    {
      throw std::exception("Fahrt unerlaubterweise gestartet");
    }
  }

  // Dieser Tester sollte vielleicht einen anderen Beruf wählen
  bool rideStarted = driver100.startRide(0);
  if (!rideStarted)
  {
    throw std::exception("Fahrt nicht gestartet");
  }
  rideStarted = driver100.startRide(2);
  if (rideStarted)
  {
    throw std::exception("Fahrt unerlaubterweise gestartet");
  }
}

int main()
{
  unitTests();
  return 0;
}
