/*
 * Lösung für Übung 11.6.3 - Ihr freundlicher Buchladen im Internet
 */
#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <iostream>
#include <string>
#include <vector>
#include <json/json.h>
#include <httplib.h>

struct Book
{
  Book(const std::string title, int pages)
    : title(title), pages(pages)
  {
  }
  const std::string title;
  const int pages;
};

std::vector<Book> parseBooks(const std::string& jsonSource)
{
  std::vector<Book> result;
  Json::Value shop;
  Json::Reader().parse(jsonSource, shop);

  Json::Value books = shop["books"];
  for (Json::Value book : books)
  {
    result.push_back(Book(book["title"].asString(), book["pages"].asInt()));
  }
  return result;
}

int main()
{
  httplib::Client client("https://cpp.hasper.info");
  client.set_follow_location(true);

  // Get-Anfrage abschicken. Das Sonderzeichen Ü muss codiert werden
  // https://cpp.hasper.info/lösungen/11_6_3.json
  httplib::Result result = client.Get("/l%C3%B6sungen/11_6_3.json");
  if (result != nullptr)
  {
    // Server wurde erreicht
    if (result->status / 100 != 2)
    {
      std::cerr << "HTTP status: " << result->status
        << " - " << result->reason << std::endl;
      return 1;
    }
    std::vector<Book> books = parseBooks(result->body);
    for (Book book : books)
    {
      std::cout << book.title << ", " << book.pages << " Seiten." << std::endl;
    }
  }
  else
  {
    // Server nicht erreicht
    std::cerr << "Verbindungsfehler" << std::endl;
  }
  return 0;
}
