/*
 * Lösung für Übung 11.6.2 -	Buchladen Jason
 */
#include <iostream>
#include <string>
#include <vector>
#include <json/json.h>

int main()
{
  std::vector<std::string> bookTitles;
  // Zeilenumbrüche können in JSON auch weggelassen werden
  const std::string jsonSource = 
                      "{"
                          "\"shopName\": \"Buchladen Jason\","
                          "\"books\": ["
                              "{"
                                  "\"title\": \"Python 3 Schnelleinstieg\","
                                  "\"pages\": 288"
                              "},"
                              "{"
                                  "\"title\": \"Machine Learning kompakt\","
                                  "\"pages\": 200"
                              "}"
                          "]"
                      "}";
  Json::Value shop;
  Json::Reader().parse(jsonSource, shop);

  Json::Value books = shop["books"];
  for (Json::Value book : books)
  {
    bookTitles.push_back(book["title"].asString());
  }

  // Natürlich könnte man das alles auch in einer einzelnen for-Schleife machen,
  // aber die Aufgabe war ja explizit, die Titel in einer Liste zu speichern.
  std::cout << "Folgende B\201cher sind im Lager: " << std::endl;
  for (std::string title : bookTitles)
  {
    std::cout << title << std::endl;
  }

  return 0;
}
