/*
 * Lösung für Übung 11.6.1 - Fehlercodes
 */
#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <httplib.h>
#include <iostream>
#include <string>
#include <map>

const std::map<int, std::string> categoryTitles = {
  { 1, "Anfrage ist in Bearbeitung" },
  { 2, "Alles in Ordnung" },
  { 3, "Anfrage wurde umgeleitet" },
  { 4, "Nicht gefunden" },
  { 5, "Server ist ausgelastet" }
};

std::string statusMessage(int httpStatusCode)
{
  int cat = httpStatusCode / 100;
  if (categoryTitles.find(cat) != categoryTitles.end())
  {
    return categoryTitles.at(cat);
  }
  return "";
}

// Alternative Lösung mit switch case
std::string statusMessageSwitch(int httpStatusCode)
{
  switch (httpStatusCode / 100)
  {
    case 1:
      return "Anfrage ist in Bearbeitung";
    case 2:
      return "Alles in Ordnung";
    case 3:
      return "Anfrage wurde umgeleitet";
    case 4:
      return "Nicht gefunden";
    case 5:
      return "Server ist ausgelastet";
    default:
      return "";
  }
}

int main()
{
  httplib::Client client("http://de.wikipedia.org");
  client.set_follow_location(true);
  httplib::Result result = client.Get("/w4godfgfkg");
  if (result != nullptr)
  {
    // Server wurde erreicht
    std::cout << result->status << ", " << result->reason << std::endl;
    std::cout << statusMessage(result->status) << std::endl;
    // Alternative Funktion
    std::cout << statusMessageSwitch(result->status) << std::endl;
  }
  else
  {
    // Server nicht erreicht
    std::cerr << "Verbindungsfehler" << std::endl;
  }
  return 0;
}
