/*
 * Bonus-Lösung für Übung 10.4.2 - Gigafabrik
 *
 * Basiert auf 10_4_2_Gigafabrik.cpp, hinzugefügt wurde der Verbrauch pro 100km
 */
#include <iostream>
#include <string>

class Car
{
 public:
  Car(const std::string modelName, int year)
    : modelName(modelName), year(year)
  {
  }
  void drive()
  {
    std::cout << modelName << " f\204hrt" << std::endl;
    consumePower();
  }
  virtual void consumePower() = 0;
 private:
  const std::string modelName;
  const int year;
};

class DieselCar : public Car
{
public:
  // Konstruktor ruft den Konstruktor der Oberklasse auf
  DieselCar(const std::string modelName, int year, int litersPer100km)
    : Car(modelName, year), litersPer100km(litersPer100km)
  {
  }
  void consumePower() override
  {
    std::cout << litersPer100km << "l Diesel verbraucht" << std::endl;
  }
private:
  const int litersPer100km;
};

class ElectricCar : public Car
{
public:
  // Konstruktor ruft den Konstruktor der Oberklasse auf
  ElectricCar(const std::string modelName, int year, int kWhPer100km)
    : Car(modelName, year), kWhPer100km(kWhPer100km)
  {
  }
  void consumePower() override
  {
    std::cout << kWhPer100km << "kWh Strom verbraucht" << std::endl;
  }
private:
  const int kWhPer100km;
};

int main()
{
  DieselCar firstCar("320d", 2018, 5);
  ElectricCar secondCar("320e", 2021, 15);
  firstCar.drive();
  secondCar.drive();
  return 0;
}
