/*
 * Lösung für Übung 10.4.2 - Gigafabrik
 */
#include <iostream>
#include <string>

class Car
{
 public:
  Car(const std::string modelName, int year)
    : modelName(modelName), year(year)
  {
  }
  void drive()
  {
    std::cout << modelName << " f\204hrt" << std::endl;
    consumePower();
  }
  virtual void consumePower() = 0;
 private:
  const std::string modelName;
  const int year;
};

class DieselCar : public Car
{
public:
  // Konstruktor ruft den Konstruktor der Oberklasse auf
  DieselCar(const std::string modelName, int year)
    : Car(modelName, year)
  {
  }
  void consumePower() override
  {
    std::cout << "Diesel verbraucht" << std::endl;
  }
};

class ElectricCar : public Car
{
public:
  // Konstruktor ruft den Konstruktor der Oberklasse auf
  ElectricCar(const std::string modelName, int year)
    : Car(modelName, year)
  {
  }
  void consumePower() override
  {
    std::cout << "Strom verbraucht" << std::endl;
  }
};

int main()
{
  DieselCar firstCar("320d", 2018);
  ElectricCar secondCar("320e", 2021);
  firstCar.drive();
  secondCar.drive();
  return 0;
}
