/*
 * Lösung für Übung 10.4.1 - Mit besten Referenzen
 *
 * - Vergessen Sie das "virtual" beim Destruktor nicht!
 * - Die Konsolenausgabe wird so aussehen:
 *        A Konstruktor
 *        A als Referenz
 *        A ohne Referenz
 *        A Destruktor
 *        Programm fertig
 *        A Destruktor
 * - Für die zweite Funktion wurde eine Kopie angelegt.
 *   Für diese Kopie wurde nicht der angegebene Konstruktor aufgerufen,
 *   (sondern ein automatischer Copy-Constructor) daher gibt es dort keine Ausgabe.
 * - Allerdings wird ganz normal der Destruktor für das kopierte Objekt aufgerufen.
 *   Daher eine Destruktorausgabe für die Kopie und danach noch eine für das
 *   originale Objekt.
 * - Sie können testweise auch den Zeiger des Objektes ausgeben lassen, damit sehen Sie noch
 *   besser, wann eine Kopie im Speicher angelegt wurde.
 *   Ersetzen Sie  hierfür die beiden Stellen
 *     << name <<
 *   durch:
 *     << this <<
 *   und die beiden Stellen
 *     << param.name <<
 *   durch:
 *     << &param <<
 */
#include <iostream>
#include <string>

class ReferenceTester
{
 public:
  // Konstruktor
  ReferenceTester(const std::string& name)
    : name(name)
  {
    std::cout << name << " Konstruktor" << std::endl;
  }
  // Destruktor
  virtual ~ReferenceTester()
  {
    std::cout << name << " Destruktor" << std::endl;
  }
  const std::string name;
};

void withReference(const ReferenceTester& param)
{
  std::cout << param.name << " als Referenz" << std::endl;
}
void withoutReference(ReferenceTester param)
{
  std::cout << param.name << " ohne Referenz" << std::endl;
}
int main()
{
  ReferenceTester testObject("A");
  withReference(testObject);
  withoutReference(testObject);
  std::cout << "Programm fertig" << std::endl;
  return 0;
}
