#include <iostream>
#include <memory>  // Für den Typ des Smart Pointers

int main()
{
  std::shared_ptr<int> pointer = std::make_shared<int>(4);
  std::cout << "1: *pointer " << *pointer << std::endl;
  // Ohne Angabe sind Smart Pointer AUTOMATISCH nullptr
  std::shared_ptr<int> pointer2;
  // Ausgabe der Adresse: (Dereferenzieren würde crashen!)
  std::cout << "2: pointer2 " << pointer2 << std::endl;

  if (true)
  {
    std::shared_ptr<int> pointer3;
    pointer3 = std::make_shared<int>(35);
    pointer2 = pointer3;
    std::cout << "3: *pointer2 " << *pointer2 << std::endl;

    // Wie bei normalen Zeigern auch ändert sich der
    // Wert bei allen, die auf denselben Speicher zeigen
    *pointer3 = 11;
    std::cout << "4: *pointer2 " << *pointer2 << std::endl;
  }
  // pointer3 verlässt den Gültigkeitsbereich, aber pointer2
  // hat immer noch Zugriff auf den gemeinsamen Speicher.
  std::cout << "5: *pointer2 " << *pointer2 << std::endl;
  // Das Prüfen auf nullptr geht genauso wie bei Zeigern:
  if (pointer2 != nullptr)
  {
    std::cout << "6: pointer2 ist nicht Null" << std::endl;
  }
  return 0;
}
// Nach Ende des Programms wurden pointer und
// pointer2 automatisch aufgeräumt
