#include <fstream>
#include <string>
#include <iostream>
int main()
{
  const std::string filePath = "test.txt";
  // ofstream steht für "output file stream"
  std::ofstream outputFile(filePath);
  outputFile << "Eine Testausgabe";
  // Die Datei muss geschlossen werden, damit sie
  // geschrieben wird
  outputFile.close();
  std::cout << "-- Datei geschrieben --" << std::endl;

  // ifstream steht für "input file stream"
  std::ifstream inputFile(filePath);
  if (!inputFile.good())
  {
    std::cerr << "Konnte Datei " << filePath
      << " nicht lesend \224ffnen!" << std::endl;
    return 1;
  }
  std::string textFromFile;
  std::getline(inputFile, textFromFile);
  std::cout << "Inhalt: " << textFromFile << std::endl;
  return 0;
}
