#include <nana/gui.hpp>
#include <nana/gui/widgets/label.hpp>

int main()
{
  // Ein Nana-Formular als Basis des Fensters anlegen
  nana::form window;
  window.caption("Textformatierung");

  nana::label labelA(window);
  nana::label labelB(window);
  nana::label labelC(window);
  nana::label labelD(window);

  labelA.format(true);
  labelA.caption("Teilweise <bold>fett</>");

  labelB.format(true);
  labelB.caption("<blue>Blau</> <red>Rot</> Schwarz");

  labelC.format(true);
  labelC.caption("<size=20>Riesig</> Klein");

  labelD.format(true);
  labelD.caption("<bold blue>Fettes Blau</>");

  // Die Label dem Layout hinzufügen
  window.div("vertical margin=10 <a><b><c><d>");
  window["a"] << labelA;
  window["b"] << labelB;
  window["c"] << labelC;
  window["d"] << labelD;
  window.collocate();

  // Fenster anzeigen und Nana starten
  window.show();
  nana::exec();

  return 0;
}
