#include <iostream>
#include <nana/gui.hpp>
#include <nana/gui/widgets/label.hpp>
#include <nana/gui/widgets/button.hpp>
int main()
{
  // Ein Nana-Formular als Basis des Fensters anlegen
  nana::form window;
  window.caption("C++ Schnelleinstieg");

  // Ein Text-Label anlegen. Es soll zentriert sein.
  nana::label textLabel(window, "Hallo Welt!");
  textLabel.text_align(nana::align::center, nana::align_v::center);

  // Eine Schaltfläche mit Click-Funktion anlegen
  nana::button button(window, "Beenden");
  button.events().click([&]() {
      window.close();
    });
  // Ein Resize-Event registrieren
  window.events().resizing(
    [](const nana::arg_resizing& a)
    {
      // arg_resizing ist ein struct, in dem die Größe steht
      std::cout << a.width << "x" << a.height << std::endl;
    });

  // Beide Elemente dem Layout hinzufügen
  window.div("vertical <myText><button>");
  window["myText"] << textLabel;
  window["button"] << button;
  window.collocate();

  // Fenster anzeigen und Nana starten
  window.show();
  nana::exec();

  return 0;
}
