#include <iostream>
#include <vector>
#include <string>

std::vector<std::string> split(const std::string& str)
{
  std::vector<std::string> parts;
  size_t start = 0;
  size_t end = str.find(',');
  while (end != std::string::npos)
  {
    parts.push_back(str.substr(start, end - start));
    start = end + 1;
    end = str.find(',', start);
  }
  parts.push_back(str.substr(start, end));
  return parts;
}

class Person
{
 public:
  Person(const std::string& f, const std::string& l, int a)
    : firstName(f), lastName(l), age(a)
  {
  }
  Person(const std::string& input)
  {
    std::vector<std::string> parts = split(input);
    if (parts.size() == 3)
    {
      lastName = parts.at(0);
      firstName = parts.at(1);
      age = std::stoi(parts.at(2));
    }
  }
  Person()
  {
  }
  std::string toString()
  {
    return lastName + ", " + firstName
      + ". Alter: " + std::to_string(age);
  }
  std::string firstName;
  std::string lastName;
  int age = -1;
};

class Room
{
 public:
  Room(const std::string& n, int c, int p)
    : name(n), capacity(c), pricePerPerson(p)
  {
  }
  bool book(const Person& person, int maxPrice)
  {
    if (pricePerPerson <= maxPrice  // Preis okay
      && persons.size() < capacity)  // Frei
    {
      persons.push_back(person);
      return true;
    }
    // Dieser Raum eignet sich nicht
    return false;
  }
  const std::string name;
  const int capacity;
  const int pricePerPerson;
  std::vector<Person> persons;
};

class Hotel
{
 public:
  Hotel(const std::string& n, const std::vector<Room>& r)
    : name(n), rooms(r)
  {
  }
  bool book(const Person& person, int maxPrice)
  {
    // Einen freien Raum finden, der dem Preis genügt
    // Wichtig: Per Referenz auf den Raum zugreifen!
    for (Room& room : rooms)
    {
      if (room.book(person, maxPrice))
      {
        return true;
      }
    }
    // Keinen Raum gefunden
    return false;
  }
  std::string toString()
  {
    std::string output = "Belegung Hotel " + name + ":\n"
      + "=============================\n";
    for (Room room : rooms)
    {
      output += "Raum " + room.name + ":\n";
      for (Person person : room.persons)
      {
        output += person.toString() + "\n";
      }
      if (room.persons.empty())  // analog zu .size() == 0
      {
        output += "  Leer\n";
      }
      output += "-----------------------------\n";
    }
    return output;
  }
  const std::string name;
  std::vector<Room> rooms;
};

int main()
{
  const std::vector<Room> rooms = {
    Room("101", 2, 40),
    Room("102", 2, 50),
    Room("103", 6, 20),
    Room("104", 1, 70)
  };
  Hotel hotel("California", rooms);

  // Interaktive Buchung
  std::cout << "Buchungssystem" << std::endl;
  while (true)
  {
    std::cout << "Nachname,Vorname,Alter:" << std::endl;
    // String über die Konsole entgegennehmen
    std::string input;
    std::getline(std::cin, input);
    // String an den Konstruktor übergeben
    Person person(input);
    if (person.age < 0)
    {
      // Hieran erkennen wir eine "ungültige" Person
      std::cerr << "Eingabefehler!" << std::endl;
    }
    else
    {
      std::cout << "Maximalpreis: ";
      std::getline(std::cin, input);
      int maxPrice = std::stoi(input);
      if (hotel.book(person, maxPrice))
      {
        std::cout << "Zimmer gefunden!" << std::endl;
        std::cout << hotel.toString();
      }
      else
      {
        std::cout << "Kein Zimmer gefunden!" << std::endl;
      }
    }
  }
  return 0;
}
