#include <iostream>
#include <vector>
#include <string>

class Person
{
 public:
  Person(const std::string& f, const std::string& l, int a)
    : firstName(f), lastName(l), age(a)
  {
  }
  Person()
  {
    // Wenn Sie mit den Standardwerten zufrieden sind
    // (siehe unten age = -1), könnten Sie den Konstruktor
    // auch leer lassen. Oder Sie schreiben beliebigen
    // anderen Code hinein, wie folgenden:
    std::cout << "Nutze Standardkonstruktor" << std::endl;
  }
  std::string firstName;
  std::string lastName;
  int age = -1;
};

Person getOldestPerson(const std::vector<Person>& persons)
{
  Person oldest;
  for (Person person : persons)
  {
    if (person.age > oldest.age)
    {
      oldest = person;
    }
  }
  return oldest;
}

int main()
{
  Person emptyPerson;
  Person melanie("Melanie", "Muster", 42);
  std::cout << melanie.lastName << "," << melanie.firstName
    << ". Alter: " << melanie.age << std::endl;

  Person markus("Markus", "Muster", 41);
  // Nutze die überladene Funktion mit std::vector
  std::vector<Person> persons = { emptyPerson, melanie, markus };
  std::cout << "\216lteste Person: "
    << getOldestPerson(persons).firstName << std::endl;
  return 0;
}
