#include <iostream>
#include <vector>
#include <string>

struct Person
{
  std::string firstName;
  std::string lastName;
  int age = -1;
};

Person getOldestPerson(const Person& a, const Person& b)
{
  if (a.age > b.age)
  {
    return a;
  }
  else
  {
    return b;
  }
}

Person getOldestPerson(const std::vector<Person>& persons)
{
  Person oldest;
  for (Person person : persons)
  {
    if (person.age > oldest.age)
    {
      oldest = person;
    }
  }
  return oldest;
}

int main()
{
  Person melanie;
  melanie.firstName = "Melanie";
  melanie.lastName = "Muster";
  melanie.age = 42;
  std::cout << melanie.lastName << ", " << melanie.firstName
    << ". Alter: " << melanie.age << std::endl;

  Person markus;
  markus.firstName = "Markus";
  markus.lastName = "Muster";
  markus.age = 41;
  if (melanie.age > markus.age)
  {
    std::cout << "Melanie ist \204lter" << std::endl;
  }

  // Nutze die Funktion für die Altersbestimmung
  std::cout << "\216lteste Person: "
    << getOldestPerson(melanie, markus).firstName
    << std::endl;
  // Nutze die überladene Funktion mit std::vector
  std::vector<Person> persons = { melanie, markus };
  std::cout << "\216lteste Person: "
    << getOldestPerson(persons).firstName
    << std::endl;
  return 0;
}
