#include <ctime>  // Für den Zugriff auf die aktuelle Zeit
#include <iostream>

enum class Day { Sunday, Monday, Tuesday, Wednesday,
                 Thursday, Friday, Saturday };
int main()
{
  // Das aktuelle Datum abrufen.
  std::time_t now = std::time(0);
  std::tm time;
  localtime_s(&time, &now);
  // Hinweis: Wenn Sie nicht unter Windows programmieren,
  // müssen Sie die obige Zeile austauschen mit:
  // localtime_r(&now, &time);

  // Das Zeitobjekt in einen unserer Enums umwandeln.
  // Da Enums intern als Zahlen abgespeichert werden,
  // kann man von der Zahl in den Enum casten.
  const Day day = static_cast<Day>(time.tm_wday);
  switch (day)
  {
  case Day::Monday:
    std::cout << "Oh je, Montag..." << std::endl;
    break;
  case Day::Tuesday:  // Intentional fall-throughs
  case Day::Wednesday:
  case Day::Thursday:
    std::cout << "Durchhalten!" << std::endl;
    break;
  case Day::Friday:
    std::cout << "Bald ist Wochenende" << std::endl;
    break;
  case Day::Saturday:
  case Day::Sunday:
    std::cout << "Herrlich, Wochenende!" << std::endl;
    break;
  default:
    // Kann nur sein, falls ein Wochentag vergessen wurde
    return 1;
  }
  const Day favouriteDay = Day::Friday;
  if (day == favouriteDay)
  {
    std::cout << "Heute ist der beste Tag" << std::endl;
  }
  return 0;
}
