#include <iostream>
#include <string>
#include <map>

const std::map<std::string, char> replacements = {
  {"ä", '\204'},
  {"Ä", '\216'},
  {"ö", '\224'},
  {"Ö", '\231'},
  {"ü", '\201'},
  {"Ü", '\232'},
  {"ß", '\341'}
};

std::string encodeUmlauts(std::string input)
{
  // Stringlänge zu einer Vorzeichenzahl konvertieren
  for (int i=0; i < static_cast<int>(input.size())-1; i++)
  {
    // Für die Sonderzeichen zwei Zeichen extrahieren
    std::string codepoint = input.substr(i, 2);
    // Wenn replacementMap.find() das Ergebnis nicht
    // findet, wird replacementMap.end() zurückgegeben
    if (replacements.find(codepoint) != replacements.end())
    {
      // Die zwei Zeichen an der Stelle i ersetzen:
      // Alles bis zur Stelle i, dann die Ersetzung und
      // dann den Rest nach den zwei Zeichen zusammenfügen.
      char replacementChar = replacements.at(codepoint);
      input = input.substr(0, i)
        + replacementChar + input.substr(i + 2);
    }
  }
  return input;
}

std::string decodeUmlauts(std::string input)
{
  for (int i = 0; i < input.size(); i++)
  {
    // Um das Element in std::map anhand des Wertes zu
    // finden, müssen Sie händisch durch die Map gehen
    for (std::pair<std::string, char> entry : replacements)
    {
      // Beim umgekehrten Weg müssen Sie nur jeweils ein
      // Zeichen ersetzen:
      if (input.at(i) == entry.second)
      {
        input = input.substr(0, i)
          + entry.first + input.substr(i + 1);
        // Zeichen wurde ersetzt. Das heißt Sie können die
        // Suche in der Map abbrechen und weitergehen
        break;
      }
    }
  }
  return input;
}

int main()
{
  std::cout << encodeUmlauts("Das ist überraschend.")
    << std::endl;
  // Ergebnis: "Das ist \201berraschend. \204\224\201"
  // Die Konsole gibt die Sonderzeichen damit korrekt aus.

  std::string input;
  while (true)
  {
    std::getline(std::cin, input);
    input = decodeUmlauts(input);
    if (input == "Überrasch mich")
    {
      std::cout << "Buhh!!" << std::endl;
    }
    if (input == "exit")
    {
      break;  // while-Schleife verlassen
    }
  }
  return 0;
}
// Hinweis für Profis: std::string hat auch eine replace()-
// Methode. Diese könnte man wie folgt oben verwenden:
// In decodeUmlauts():
//   input.replace(i, 2, 1, replacements.at(codepoint));
// In encodeUmlauts():
//   input.replace(i, 1, entry.first);
