#include <iostream>
#include <string>
#include <vector>

std::vector<std::string> split(const std::string& str,
  char delimiter = ',')
{
  std::vector<std::string> parts;
  size_t start = 0;
  size_t end = str.find(delimiter);
  // Wenn die Suche zu keinem Ergebnis führt, nimmt der
  // Rückgabewert den speziellen Wert npos an
  while (end != std::string::npos)
  {
    parts.push_back(str.substr(start, end - start));
    start = end + 1;
    end = str.find(delimiter, start);
  }
  parts.push_back(str.substr(start, end));
  return parts;
}

int parseDate(const std::string& str)
{
  std::vector<std::string> parts = split(str, '.');
  if (parts.size() != 3)
  {
    std::cerr << "Datum ung\201ltig: " << str << std::endl;
    return -1;
  }
  int day = std::stoi(parts.at(0));
  int month = std::stoi(parts.at(1));
  int year = std::stoi(parts.at(2));
  return year * 10000 + month * 100 + day;
}

int main()
{
  std::vector<std::string> inputs = {
    "4.6.2003",
    "17.11.1993",
    "03.09.2025",
    "invalid"
  };
  std::vector<int> outputs = {
    20030604,
    19931117,
    20250903,
    -1
  };
  for (int i = 0; i < outputs.size(); i++)
  {
    if (outputs.at(i) != parseDate(inputs.at(i)))
    {
      std::cerr << "Parsingfehler bei " << inputs.at(i)
        << std::endl;
      return 1;
    }
  }
  return 0;
}
