#include <iostream>
#include <string>
#include <vector>

std::vector<std::string> split(const std::string& str)
{
  std::vector<std::string> parts;
  size_t start = 0;
  size_t end = str.find(',');
  // Wenn die Suche zu keinem Ergebnis führt, nimmt der
  // Rückgabewert den speziellen Wert npos an
  while (end != std::string::npos)
  {
    parts.push_back(str.substr(start, end - start));
    start = end + 1;
    end = str.find(',', start);
  }
  parts.push_back(str.substr(start, end));
  return parts;
}

int main()
{
  std::string example = "Ein Beispiel";
  example.at(4);  // B
  example.at(3);  // Das Leerzeichen
  // example.at(23);  // Zugriffsfehler

  // Anfangsindex und Länge angegeben. Ergebnis: Bei
  std::string sub1 = example.substr(4, 3);
  // Ab Index 4 alles bis zum Ende. Ergebnis: Beispiel
  std::string sub2 = example.substr(4);
  // Alles außer dem letzten Zeichen. Ergebnis: Ein Beispie
  std::string sub3 = example.substr(0, example.size()-1);

  // Alles bis zum ersten Leerzeichen. Ergebnis: Ein
  std::string sub4 = example.substr(0, example.find(' '));
  // Alles nach dem ersten Leerzeichen. Ergebnis: Beispiel
  // Um das Leerzeichen zu überspringen, 1 addieren
  std::string sub5 = example.substr(example.find(' ') + 1);

  std::vector<std::string> list = split("rad,bahn,auto");
  return 0;
}
