#include <vector>
#include <iostream>

int factorial(int number)
{
  if (number == 0)
  {
    return 1;
  }
  return number * factorial(number - 1);
}

int factorialIterative(int number)
{
  int result = 1;
  for (int i = 2; i <= number; i++)
  {
    result *= i;
  }
  return result;
}

int main()
{
  std::cout << "4! = " << factorial(4) << std::endl;
  /*
   * Test-Code für die Berechnung der Fakultät
   */
  const std::vector<int> tests = { 6, 0, 1 };
  const std::vector<int> expected = { 720, 1, 1 };

  for (int i = 0; i < tests.size(); i++)
  {
    if (factorial(tests.at(i)) != expected.at(i))
    {
      std::cerr << "factorial(" << tests.at(i)
        << ") ist falsch" << std::endl;
      return 1;
    }
    if (factorialIterative(tests.at(i)) != expected.at(i))
    {
      std::cerr << "factorialIterative(" << tests.at(i)
        << ") ist falsch" << std::endl;
      return 1;
    }
  }
  return 0;
}
