#include <iostream>
#include <vector>
#include <exception>

int factorial(int number)
{
  if (number == 0)
  {
    return 1;
  }
  return number * factorial(number - 1);
}

void unitTests()
{
  // Test-Code für die Berechnung der Fakultät
  const std::vector<int> tests = { 6, 0, 1 };
  const std::vector<int> expected = { 720, 1, 1 };

  for (int i = 0; i < tests.size(); i++)
  {
    int actual = factorial(tests.at(i));
    if (actual != expected.at(i))
    {
      std::cerr << tests.at(i) << "! ergab "
        << actual << ", erwartet wurde "
        << expected.at(i) << std::endl;
      throw std::exception("factorial() is broken!");
    }
  }
}

int main()
{
  unitTests();

  int number;
  std::cout << "Zahl zwischen 0 und 12 eingeben: ";
  std::cin >> number;
  std::cout << std::endl << "Fakult\204t: " << factorial(number)
    << std::endl;
  return 0;
}
