#include <ctime>
#include <fstream>
#include <iomanip>
#include <iostream>
#include <memory>
#include <string>

class Logger
{
 public:
  Logger()
  {
    outputFile = std::ofstream("log.txt", std::ios_base::app);
    writeTime(outputFile);
    outputFile << " --Logging gestartet--\n";
    outputFile.flush();
  }
  void log(const std::string& line)
  {
    writeTime(outputFile);
    outputFile << " " << line << "\n";
    outputFile.flush();
  }
 private:
  std::tm currentTime()
  {
  }
  void writeTime(std::ofstream& stream)
  {
    // Das aktuelle Datum abrufen
    std::time_t now = std::time(0);
    std::tm time;
    localtime_s(&time, &now);
    // Hinweis: Wenn Sie nicht unter Windows programmieren:
    // localtime_r(&now, &time);
    stream << std::put_time(&time, "%Y-%m-%d %H:%M:%S");
  }
  std::ofstream outputFile;
};

int main()
{
  Logger logger;
  logger.log("1");
  std::shared_ptr<int> pointer;
  logger.log("2");
  pointer = 0;
  logger.log("3");
  std::cout << *pointer << std::endl;
  logger.log("4");
  *pointer = 17;
  logger.log("5");
  return 0;
}
// Achtung, dieses Beispiel provoziert einen nullpointer!
