#include <json/json.h>
#include <iostream>
#include <string>

struct Question
{
  std::string question;
  std::string answer;
  int category = 0;
  void read(const std::string& str)
  {
    // Deserialisierung: Auslesen aus einem String
    Json::Value jsonObj;
    Json::Reader().parse(str, jsonObj);
    // Abruf der gewünschten Eigenschaften
    question = jsonObj["question"].asString();
    answer = jsonObj["answer"].asString();
    category = jsonObj["category"].asInt();
  }
  std::string write() const
  {
    // Serialisierung: Abspeichern in einem String
    Json::StreamWriterBuilder factory;
    Json::Value jsonObj;
    jsonObj["question"] = question;
    jsonObj["answer"] = answer;
    jsonObj["category"] = category;
    return Json::writeString(factory, jsonObj);
  }
};

int main()
{
  Question q1;
  q1.question = "Was macht es?";
  q1.answer = "Es leuchtet blau";
  q1.category = 2;
  std::cout << q1.write() << std::endl;
  Question q2;
  q2.read(q1.write());
  std::cout << q2.write() << std::endl;
  return 0;
}
