#include <json/json.h>
#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <httplib.h>
#include <string>
#include <iostream>
#include <nana/gui.hpp>
#include <nana/gui/widgets/label.hpp>
#include <nana/gui/widgets/textbox.hpp>
#include <nana/gui/widgets/button.hpp>

int main()
{
  // Ein Nana-Formular als Basis des Fensters anlegen
  nana::form window;
  window.caption("Wikipedia-Suche");

  // Die GUI-Elemente anlegen
  nana::label txt(window);
  txt.text_align(nana::align::center, nana::align_v::center);
  nana::textbox input(window);
  input.multi_lines(false);
  nana::button button(window, "Senden");

  // Das Label dem Layout hinzufügen
  window.div("vertical"
    "<txt margin=10>"
    "<height=30 <input><button fit>>");
  window["txt"] << txt;
  window["input"] << input;
  window["button"] << button;
  window.collocate();

  // Mit dem deutschen Wikipedia-Server reden
  httplib::Client client("https://de.wikipedia.org");
  client.set_follow_location(true);

  // API-Optionen wählen, die einen kurzen Absatz liefern
  const std::string wikiApi = "/w/api.php?action=query&redirects=1"
    "&format=json&utf8=1&prop=extracts&explaintext=1&exsentences=2"
    "&titles=";

  button.events().click([&]() {
    if (input.text().empty())
    {
      // Kein Suchtext vorhanden. Nichts machen
      return;
    }
    // Das gewünschte Schlüsselwort anhängen
    std::string query = wikiApi + input.text();

    // Get-Anfrage abschicken. Die Methode verlangt leider
    // einen C-String, daher die Umwandlung mittels c_str()
    httplib::Result result = client.Get(query.c_str());
    if (result != nullptr)
    {
      // Server wurde erreicht
      if (result->status / 100 == 2)
      {
        Json::Value answer;
        // Der Reader liest den String in die Variable ein
        Json::Reader().parse(result->body, answer);
        // Aufruf der gewünschten Eigenschaften
        Json::Value pages = answer["query"]["pages"];
        std::string pageName = pages.getMemberNames().at(0);
        Json::Value page = pages[pageName];
        std::string extract = page["extract"].asString();
        // Extract in das Textlabel geben
        txt.caption(extract);
      }
      else
      {
        std::cerr << "HTTP status: " << result->status
          << " - " << result->reason << std::endl;
      }
    }
    else
    {
      // Server nicht erreicht
      std::cerr << "Verbindungsfehler" << std::endl;
    }
  });

  // Fenster anzeigen und Nana starten
  window.show();
  nana::exec();
  return 0;
}
