#include <json/json.h>
#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <httplib.h>
#include <string>
#include <iostream>

int main()
{
  // Mit dem deutschen Wikipedia-Server reden
  httplib::Client client("https://de.wikipedia.org");
  client.set_follow_location(true);

  // API-Optionen wählen, die einen kurzen Absatz liefern
  const std::string wikiApi = "/w/api.php?action=query&redirects=1"
    "&format=json&utf8=1&prop=extracts&explaintext=1&exsentences=2"
    "&titles=";
  // Das gewünschte Schlüsselwort anhängen
  std::string query = wikiApi + "C++";

  // Get-Anfrage abschicken. Die Methode verlangt leider
  // einen C-String, daher die Umwandlung mittels c_str()
  httplib::Result result = client.Get(query.c_str());
  if (result != nullptr)
  {
    // Server wurde erreicht
    if (result->status / 100 == 2)
    {
      Json::Value answer;
      // Der Reader liest den String in die Variable ein
      Json::Reader().parse(result->body, answer);
      // Zugriff auf Eigenschaften mit eckigen Klammern.
      // Bei Objekten innerhalb von Objekten (siehe #1)
      // können Sie die eckigen Klammern nacheinander
      // schreiben:
      Json::Value pages = answer["query"]["pages"];
      // Die nun folgende Eigenschaft hat keinen fest-
      // stehenden Schlüssel, sondern entspricht der
      // Page-ID (siehe #2). Daher müssen wir zuerst den
      // Schlüssel selbst abfragen.
      std::string pageName = pages.getMemberNames().at(0);
      // Der abgefragte Schlüssel kann nun in die eckigen
      // Klammern geschrieben werden. Danach folgt ein
      // weiteres Klammerpaar, in dem die Ziel-Eigenschaft,
      // der "extract", steht. Siehe #3
      Json::Value page = pages[pageName]["extract"];
      std::string extract = page.asString();
      std::cout << extract << std::endl;
    }
    else
    {
      std::cerr << "HTTP status: " << result->status
        << " - " << result->reason << std::endl;
    }
  }
  else
  {
    // Server nicht erreicht
    std::cerr << "Verbindungsfehler" << std::endl;
  }
  return 0;
}
