#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <httplib.h>
#include <string>
#include <iostream>

std::string stupidParser(const std::string& message,
  const std::string& key)
{
  // Der Schlüssel muss mit Anführungszeichen umgeben sein
  const std::string techKey = "\"" + key + "\":";
  size_t pos = message.find(techKey);
  if (pos == std::string::npos)
  {
    // Nicht gefunden
    return "";
  }
  // Das erste, öffnende Anführungszeichen nach dem Ende
  // des Schlüsselworts
  size_t first = message.find('\"', pos + techKey.size());
  if (first == std::string::npos)
  {
    std::cerr << "Ung\201ltiges JSON: " << message << std::endl;
    return "";
  }
  // Das zweite Anführungszeichen ist schon schwieriger,
  // denn es dürfte auch innerhalb des Textes auftauchen
  // und nicht nur am Ende. Da es in diesem Falle aber mit
  // einem Backslash codiert sein müsste, suchen Sie dann
  // weiter, wenn ein Backslash davor steht
  size_t second = message.find('\"', first + 1);
  while (second != std::string::npos
    && message.at(second - 1) == '\\')
  {
    // Ab dem gefundenen codierten Zeichen weitersuchen
    second = message.find('\"', second + 1);
  }
  if (second == std::string::npos)
  {
    std::cerr << "Ung\201ltiges JSON: " << message << std::endl;
    return "";
  }
  // Eins addieren, um das Anführungszeichen auszuschließen
  first++;
  // first und second sind Indizes. Daher erhalten Sie die
  // Länge des gewünschten Substrings, indem Sie sie
  // voneinander abziehen.
  return message.substr(first, second - first);
}

int main()
{
  // Mit dem deutschen Wikipedia-Server reden
  httplib::Client client("https://de.wikipedia.org");
  client.set_follow_location(true);

  // API-Optionen wählen, die einen kurzen Absatz liefern
  const std::string wikiApi = "/w/api.php?action=query&redirects=1"
    "&format=json&utf8=1&prop=extracts&explaintext=1&exsentences=2"
    "&titles=";
  // Das gewünschte Schlüsselwort anhängen
  std::string query = wikiApi + "C++";

  // Get-Anfrage abschicken. Die Methode verlangt leider
  // einen C-String, daher die Umwandlung mittels c_str()
  httplib::Result result = client.Get(query.c_str());
  if (result != nullptr)
  {
    // Server wurde erreicht
    if (result->status / 100 == 2)
    {
      std::cout << stupidParser(result->body, "extract")
        << std::endl;
    }
    else
    {
      std::cerr << "HTTP status: " << result->status
        << " - " << result->reason << std::endl;
    }
  }
  else
  {
    // Server nicht erreicht
    std::cerr << "Verbindungsfehler" << std::endl;
  }
  return 0;
}
