#define CPPHTTPLIB_OPENSSL_SUPPORT
#include <httplib.h>
#include <string>
#include <iostream>

int main()
{
  // Mit dem deutschen Wikipedia-Server reden
  httplib::Client client("https://de.wikipedia.org");
  client.set_follow_location(true);

  // API-Optionen wählen, die einen kurzen Absatz liefern
  const std::string wikiApi = "/w/api.php?action=query&redirects=1"
    "&format=json&utf8=1&prop=extracts&explaintext=1&exsentences=2"
    "&titles=";
  // Das gewünschte Schlüsselwort anhängen
  std::string query = wikiApi + "C++";

  // Get-Anfrage abschicken. Die Methode verlangt leider
  // einen C-String, daher die Umwandlung mittels c_str()
  httplib::Result result = client.Get(query.c_str());
  if (result != nullptr)
  {
    // Server wurde erreicht
    if (result->status / 100 != 2)
    {
      std::cerr << "HTTP status: " << result->status
        << " - " << result->reason << std::endl;
      return 1;
    }
    std::cout << result->body << std::endl;
  }
  else
  {
    // Server nicht erreicht
    std::cerr << "Verbindungsfehler" << std::endl;
  }
  return 0;
}
