#include <iostream>
#include <vector>
#include <memory>

class Animal
{
 public:
  virtual void eat() = 0;
};

class Cat : public Animal
{
 public:
  void eat() override
  {
    std::cout << "Katze isst eine Maus" << std::endl;
  }
};

class Mouse : public Animal
{
 public:
  void eat() override
  {
    std::cout << "Maus isst K\204se" << std::endl;
  }
};

/*
 Die Version voller Compilerfehler
   error C2259: "Animal": Abstrakte Klasse kann
   nicht erstellt werden.

 Entfernen Sie den Blockkommentar, um die Fehler
 selbst zu sehen


class Worm : public Animal
{
};

int main()
{
  // Die Standardimplementierung der Oberklasse
  Animal tier;     // <- Compilerfehler
  tier.eat();

  // Jeweils eine eigene Implementierung
  Cat cat;
  cat.eat();
  Mouse mouse;
  mouse.eat();

  // Nochmals die Standardimplementierung der Oberklasse
  Worm worm;       // <- Compilerfehler
  worm.eat();

	                 // v---- Compilerfehler
  std::vector<Animal> zoo = { Animal(), Cat(), Mouse() };
  for (Animal& animal : zoo)
  {
    animal.eat();
  }
  return 0;
}

*/

class Worm : public Animal
{
 public:
  void eat() override
  {
    std::cout << "Wurm frisst Kompost" << std::endl;
  }
};

int main()
{
  Cat cat;
  cat.eat();
  Mouse mouse;
  mouse.eat();
  Worm worm;
  worm.eat();

  std::vector<std::shared_ptr<Animal>> zoo = {
    std::make_shared<Cat>(),
    std::make_shared<Mouse>(),
    std::make_shared<Worm>()
  };
  for (std::shared_ptr<Animal> animal : zoo)
  {
    animal->eat();
  }
  return 0;
}
